/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.challenge.challenges;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.angel.challenges6t4.challenge.Challenge;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class RandomizerChallenge
extends Challenge {
    private Map<class_1792, class_1792> itemDropMap = new HashMap<class_1792, class_1792>();
    private Map<class_1299<?>, List<class_1792>> entityDropMap = new HashMap();
    private List<class_1792> allItems = new ArrayList<class_1792>();
    private class_5819 random;
    private long worldSeed = 0L;
    private boolean initialized = false;

    public RandomizerChallenge() {
        super("randomizer", (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.randomizer.name"), (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.randomizer.description"), false);
    }

    @Override
    public boolean isGameBeatable() {
        return true;
    }

    @Override
    public void onEnable() {
        this.initialized = false;
    }

    @Override
    public void onDisable() {
        this.itemDropMap.clear();
        this.entityDropMap.clear();
        this.initialized = false;
    }

    public void initializeForWorld(class_1937 world) {
        if (this.initialized) {
            return;
        }
        String dimensionKey = world.method_27983().method_29177().toString();
        int spawnX = world.method_43126().method_10263();
        int spawnZ = world.method_43126().method_10260();
        this.worldSeed = dimensionKey.hashCode() * 31 + spawnX * 17 + spawnZ * 13;
        this.random = class_5819.method_43049((long)this.worldSeed);
        this.populateItemList();
        this.createRandomMappings();
        this.initialized = true;
    }

    private void populateItemList() {
        this.allItems.clear();
        for (class_1792 item : class_7923.field_41178) {
            if (item == class_1802.field_8162) continue;
            this.allItems.add(item);
        }
    }

    private void createRandomMappings() {
        this.itemDropMap.clear();
        this.entityDropMap.clear();
        for (class_1792 item : this.allItems) {
            class_1792 mappedItem = this.allItems.get(this.random.method_43048(this.allItems.size()));
            this.itemDropMap.put(item, mappedItem);
        }
        for (class_1299 entityType : class_7923.field_41177) {
            int dropCount = this.random.method_43048(4) + 1;
            ArrayList<class_1792> drops = new ArrayList<class_1792>();
            for (int i = 0; i < dropCount; ++i) {
                class_1792 drop = this.allItems.get(this.random.method_43048(this.allItems.size()));
                drops.add(drop);
            }
            this.entityDropMap.put(entityType, drops);
        }
    }

    public class_1792 getRandomizedItem(class_1792 original) {
        if (!this.isEnabled() || !this.initialized) {
            return original;
        }
        return this.itemDropMap.getOrDefault(original, original);
    }

    public List<class_1792> getRandomizedEntityDrops(class_1299<?> entityType) {
        if (!this.isEnabled() || !this.initialized) {
            return new ArrayList<class_1792>();
        }
        return this.entityDropMap.getOrDefault(entityType, new ArrayList());
    }

    public void processItemEntity(class_1542 itemEntity) {
        if (!this.isEnabled() || !this.initialized) {
            return;
        }
        class_1799 stack = itemEntity.method_6983();
        class_1792 originalItem = stack.method_7909();
        class_1792 randomizedItem = this.getRandomizedItem(originalItem);
        if (randomizedItem != originalItem) {
            class_1799 newStack = new class_1799((class_1935)randomizedItem, stack.method_7947());
            itemEntity.method_6979(newStack);
        }
    }
}

